function showMostSimilarPairs(obj,N)
%SHOWMOSTSIMILARPAIRS Show the N most similar pairs in the similarity
%matrix

%S = triu(obj.S,1);
S = obj.S;
S(logical(tril(ones(size(S)),0))) = -Inf;
[vals idxs] = sort(S(:),'descend');


[I J] = ind2sub(size(S),idxs);

fprintf('%-20s%-20s%-20s\n','Neuron','Neuron','Similarity');
for kk = 1:N
    fprintf('%-20s%-20s%.5f\n',obj.Slabels{I(kk)},obj.Slabels{J(kk)},vals(kk));
end



end

